import React from 'react';
import { IntlProvider } from 'react-intl';
import messages from 'localization/ru';
import Promise from 'bluebird';
import { DndProvider } from 'react-dnd';
import { addDecorator } from '@storybook/react';
import 'material-design-icons/iconfont/material-icons.css';
import 'styles/global.css';
import store from 'store';
import { Provider } from 'react-redux';
import { configureRootTheme } from '@yandex-lego/components/Theme';
import { crmMgLightTheme } from '@crm/components/dist/lego2/Theme/presets/themes';
import { initialize, mswDecorator } from 'msw-storybook-addon';
import '../vendor/font-awesome/css/font-awesome.min.css';
import HTML5Backend from '../src/entry/components/ReactDndModifiedBackend';
import getScrollbarWidth from '../src/entry/utils/getScrollbarWidth';

// Initialize MSW
initialize();

// Provide the MSW addon decorator globally
export const decorators = [mswDecorator];

configureRootTheme({ theme: crmMgLightTheme });

window.CRM_SPACE_API_HOST = '/space';
window.CKEDITOR_BASEPATH = 'vendor/ckeditor/';
window.scrollBarWidth = getScrollbarWidth();

Promise.config({
  // Enable cancellation
  cancellation: true,
});

window.__FEATURES__ = {};

export const parameters = {
  options: {
    storySort: (a, b) =>
      a[1].kind === b[1].kind ? 0 : a[1].id.localeCompare(b[1].id, undefined, { numeric: true }),
  },
};

addDecorator((story) => (
  <DndProvider backend={HTML5Backend}>
    <IntlProvider textComponent="span" locale="ru" messages={messages}>
      <Provider store={store}>{story()}</Provider>
    </IntlProvider>
  </DndProvider>
));
