import webpack from 'webpack';
import path from 'path';
import devConfig from '../webpack/dev.config';

module.exports = async ({ config }): Promise<webpack.Configuration> => {
  const devConfigObj = devConfig({
    rootDirName: path.resolve(__dirname, '..'),
    env: 'development',
  });

  /*
    Вытащил руками правило из конфига. Потенциально может ломаться при обновлении версий. Лучшего решения не нашел.
    https://github.com/storybookjs/storybook/blob/master/addons/docs/src/frameworks/common/preset.ts#L104
  */
  const mdxRule = config.module.rules.find(rule => rule.test instanceof RegExp && rule.test.test('file.stories.mdx'));

  return {
    ...config,
    module: {
      ...config.module,
      rules: [
        ...devConfigObj.module.rules,
        /* TODO: remove next rule */
        {
          test: /\.mdx$/,
          exclude: /(stories|story)\.mdx$/,
          use: ['babel-loader', '@mdx-js/loader'],
        },
        mdxRule,
      ]
    },
    resolve: {
      ...config.resolve,
      ...devConfigObj.resolve,
    },
    plugins: config.plugins.concat([devConfigObj.plugins[0], devConfigObj.plugins[2]]),
  };
};
