const tsParser = require.resolve('@yandex-int/tanker-helpers/parsers/ts_parser.js');

const { resolve } = require('path');

const TANKER_TOKEN =
  process.env.TANKER_API_TOKEN ||
  process.env.TANKER_TOKEN ||
  require('fs')
    .readFileSync(resolve(__dirname, './token'), 'utf-8')
    .trim();

const TANKER_BRANCH = process.env.TANKER_BRANCH || 'master';
const TANKER_STATUS = process.env.TANKER_STATUS || 'unapproved';

module.exports = function(config) {
  const levels = ['src/'];

  config.tanker.project = 'crm_space';
  config.tanker.token = TANKER_TOKEN;
  config.tanker.branch = TANKER_BRANCH;
  config.tanker.status = TANKER_STATUS;

  config.finders = [
    `find ${levels.join(' ')} -name "*.tsx" -o -name "*.ts" -type f | grep -vE "/*\.i18n"`,
  ];

  config.parsers.ts = tsParser;
  config.parsers.tsx = tsParser;

  config.dispatchers.json = resolve(__dirname, 'dispatchers/json2Crm');
};
