const actions = {
  pr: {
    title: 'PR checking',
    description: 'Test action for PR checking',
    flow: 'pr-flow',
    triggers: [{ on: 'pr' }],
  },
  hermione: {
    title: 'Hermione Tests',
    description: 'Run Hermione E2E tests',
    flow: 'hermione-flow',
    'flow-vars-ui': {
      schema: {
        type: 'object',
        properties: {
          palmsync: {
            title: 'Run Palmsync',
            type: 'string',
            enum: ['No', 'Yes'],
            default: 'No',
          },
          keyword: {
            title: 'GREP by keyword',
            type: 'string',
            default: '',
          },
        },
      },
    },
  },
  'commit-into-trunk': {
    title: 'Update Dev Stage',
    description: 'Update Dev stage after commit into trunk',
    flow: 'commit-into-trunk',
    triggers: [{ on: 'commit', into: 'trunk' }],
  },
  'deploy-to-dev': {
    title: 'Deploy to Dev Stage',
    'flow-vars-ui': {
      schema: {
        type: 'object',
        properties: {
          stage: {
            title: 'Stage in deploy',
            type: 'string',
            enum: [
              'crm-frontend-dev-1',
              'crm-frontend-dev-2',
              'crm-frontend-dev-3',
              'crm-frontend-dev-4',
              'crm-frontend-dev-5',
              'crm-frontend-dev-6',
            ],
            default: 'crm-frontend-dev-1',
          },
        },
      },
    },
    description: 'Deploy build to Dev Stage',
    flow: 'deploy-to-dev',
  },
};

module.exports = { actions };
