const { calculateVersion } = require('../jobs/calculateVersion.js');
const { build } = require('../jobs/build.js');
const { deployToMds } = require('../jobs/deployToMds.js');
const { updateDeployStage } = require('../jobs/updateDeployStage.js');

const commitIntoTrunk = (stages, mdsBucket) => ({
  title: 'Update dev Stage after commit into trunk',
  jobs: {
    'calculate-version': {
      ...calculateVersion,
    },
    build: {
      ...build(mdsBucket),
      needs: 'calculate-version',
    },
    'deploy-to-mds': {
      ...deployToMds(mdsBucket),
      needs: 'build',
    },
    develop: {
      ...updateDeployStage('Deploy to Develop', stages.devStage, mdsBucket),
      needs: 'deploy-to-mds',
    },
  },
});

module.exports = { commitIntoTrunk };
