const { build } = require('../jobs/build.js');
const { calculateVersion } = require('../jobs/calculateVersion.js');
const { deployToMds } = require('../jobs/deployToMds.js');
const { updateDeployStage } = require('../jobs/updateDeployStage.js');

const deployToDevFlow = (mdsBucket) => ({
  title: 'Deploy to Dev Stage',
  jobs: {
    'calculate-version': {
      ...calculateVersion,
    },
    build: {
      ...build(mdsBucket),
      needs: 'calculate-version',
    },
    'deploy-to-mds': {
      ...deployToMds(mdsBucket),
      needs: 'build',
    },
    deploy: {
      ...updateDeployStage('Deploy to Dev Stage', '${flow-vars.stage}', mdsBucket),
      needs: 'deploy-to-mds',
    },
  },
});

module.exports = { deployToDevFlow };
