const { calculateVersion } = require('../jobs/calculateVersion.js');
const { updateSuccessVersion } = require('../jobs/updateSuccessVersion.js');
const { getIssues } = require('../jobs/getIssues.js');
const { updateTickets } = require('../jobs/updateTickets.js');
const { build } = require('../jobs/build.js');
const { deployToMds } = require('../jobs/deployToMds.js');
const { updateDeployStage } = require('../jobs/updateDeployStage.js');

const hotfixFlow = (type, stages, mdsBucket) => ({
  title: `${type === 'test' && '(TEST) '}Static hotfix`,
  jobs: {
    'calculate-version': {
      ...calculateVersion,
      stage: 'build',
    },
    build: {
      ...build(mdsBucket),
      needs: 'calculate-version',
    },
    'deploy-to-mds': {
      ...deployToMds(mdsBucket),
      stage: 'deploy-to-mds',
      needs: 'build',
    },
    hotfix: {
      ...updateDeployStage('Deploy to Hotfix', stages.hotfixStage, mdsBucket),
      needs: 'deploy-to-mds',
      stage: 'hotfix-update',
    },
    'get-issues': {
      ...getIssues,
      needs: 'hotfix',
    },
    'update-tickets': {
      ...updateTickets,
      needs: 'get-issues',
    },
    prod: {
      ...updateDeployStage('Deploy to Prod', stages.prodStage, mdsBucket, 'yes'),
      needs: 'update-tickets',
      manual: true,
      stage: 'prod',
    },
    'update-last-success-version': {
      ...updateSuccessVersion,
      needs: 'prod',
      stage: 'update-last-success-version',
    },
  },
});

module.exports = { hotfixFlow };
