const { stages, mockCommonMdsBucket, commonMdsBucket, mockStages } = require('../common');
const { releaseFlow } = require('./releaseFlow.js');
const { hotfixFlow } = require('./hotfixFlow.js');
const { commitIntoTrunk } = require('./commitIntoTrunk.js');
const { prFlow } = require('./prFlow.js');
const { deployToDevFlow } = require('./deployToDevFlow.js');
const { hermioneFlow } = require('./hermione');
const { updateSuccessVersionFlow } = require('./updateSuccessVersionFlow');

const flows = {
  'crm-release-flow': releaseFlow('prod', stages, commonMdsBucket),
  'test-release-flow': releaseFlow('test', mockStages, mockCommonMdsBucket),
  'hotfix-flow': hotfixFlow('prod', stages, commonMdsBucket),
  'test-hotfix-flow': hotfixFlow('test', mockStages, mockCommonMdsBucket),
  'pr-flow': prFlow,
  'hermione-flow': hermioneFlow,
  'update-last-success-version-flow': updateSuccessVersionFlow,
  'commit-into-trunk': commitIntoTrunk(stages, commonMdsBucket),
  'deploy-to-dev': deployToDevFlow(commonMdsBucket),
};

module.exports = { flows };
