const { unitTests } = require('../jobs/unitTests.js');
const { typesChecking } = require('../jobs/typesChecking.js');
const { prBuild } = require('../jobs/prBuild.js');
const { deployStorybook } = require('../jobs/deployStorybook.js');

const prFlow = {
  title: 'PR checking',
  jobs: {
    'start-checking': {
      title: 'Start PR checks',
      task: 'dummy',
    },
    'pr-build': {
      ...prBuild,
      needs: 'start-checking',
    },
    'unit-tests': {
      ...unitTests,
      needs: 'start-checking',
    },
    'types-checking': {
      ...typesChecking,
      needs: 'start-checking',
    },
    'deploy-storybook': {
      ...deployStorybook,
      needs: 'start-checking',
    },
  },
};

module.exports = { prFlow };
