const { calculateVersion } = require('../jobs/calculateVersion');
const { build } = require('../jobs/build.js');
const { getIssues } = require('../jobs/getIssues.js');
const { updateTickets } = require('../jobs/updateTickets.js');
const { deployToMds } = require('../jobs/deployToMds.js');
const { updateDeployStage } = require('../jobs/updateDeployStage.js');

const releaseFlow = (type, stages, mdsBucket) => ({
  title: `Static${type === 'test' && ' TEST'} release`,
  jobs: {
    'start-build': {
      title: 'Calculate Version and Build',
      task: 'dummy',
      stage: 'build',
    },
    'calculate-version': {
      ...calculateVersion,
      needs: 'start-build',
    },
    build: {
      ...build(mdsBucket),
      needs: 'calculate-version',
    },
    'deploy-to-mds': {
      ...deployToMds(mdsBucket),
      stage: 'deploy-to-mds',
      needs: 'build',
    },
    testing: {
      ...updateDeployStage('Deploy to testing', stages.testStage, mdsBucket),
      needs: 'deploy-to-mds',
      stage: 'testing',
    },
    'get-issues': {
      ...getIssues,
      needs: 'testing',
    },
    'update-tickets': {
      ...updateTickets,
      needs: 'get-issues',
    },
    mars: {
      ...updateDeployStage('Deploy to Mars', stages.marsStage, mdsBucket),
      needs: 'update-tickets',
      stage: 'mars',
      manual: true,
    },
    prod: {
      ...updateDeployStage('Deploy to Prod', stages.prodStage, mdsBucket, 'yes'),
      needs: 'mars',
      stage: 'prod',
      manual: true,
    },
    hotfix: {
      ...updateDeployStage('Deploy to Hotfix', stages.hotfixStage, mdsBucket),
      needs: 'prod',
      manual: true,
      stage: 'hotfix',
    },
  },
});

module.exports = { releaseFlow };
