const { flows } = require('./flows');
const { releases } = require('./releases');
const { actions } = require('./actions');

const ciSettings = {
  service: 'crm',
  title: 'CRM frontend static',
  arcanum: {
    auto_merge: { enabled: false },
    review: {
      auto_assign: true,
      required: true,
      disabling_policy: 'need_reason',
      min_approvers_count: 1,
      groups: [{ name: 'crm-frontend', roles: 'crm-frontend' }],
    },
  },
  ci: {
    secret: 'sec-01g3c5n4vp2a33rscnmegk2qsf',
    runtime: { 'sandbox-owner': 'CRM' },
    releases,
    actions,
    flows,
  },
};

module.exports = { ciSettings };
