const { requirements } = require('../common.js');

const build = (mdsBucket) => {
  const cmd = `cd crm/space/frontend_static
export TARGET_BUCKET_FOLDER=${mdsBucket}
bash ci/jobs/build.bash`;
  return {
    title: 'Build',
    task: 'common/misc/run_command',
    requirements,
    input: {
      config: {
        environment_variables: [
          {
            key: 'VERSION',
            value: '${tasks.calculate-version.result_output[0].string[0]}',
          },
        ],
        secret_environment_variables: [
          { key: 'TANKER_TOKEN', secret_spec: { key: 'tanker.token' } },
        ],
        arc_mount_config: { enabled: true },
        cmd_line: cmd,
        result_resources: [
          {
            path: 'dist_folder',
            description: 'Static Folder',
            type: 'OTHER_RESOURCE',
            compression_type: 'none',
          },
        ],
      },
    },
  };
};

module.exports = { build };
