const { requirements } = require('../common.js');

const cmd = `cd crm/space/frontend_static
npm install axios
node ./ci/jobs/calculateVersion.js branch=\${context.branch} launchNumber=\${context.launch_number} revision=\${context.target_revision.number} flowType=\${context.flow_type}`;

const calculateVersion = {
  title: 'Calculate Version',
  task: 'common/misc/run_command',
  requirements,
  input: {
    config: {
      arc_mount_config: { enabled: true },
      cmd_line: cmd,
      result_output: [{ path: 'version' }],
    },
  },
};

module.exports = { calculateVersion };
