const { requirements } = require('../common.js');

const cmd = `cd crm/space/frontend_static
export BRANCH=$(echo \${context.branch} | sed 's/:/-/g')
bash ci/jobs/deployStorybook.bash
echo '{ "id": "luna-1", "module": "YANDEX_DEPLOY", "url": "https://s3.mds.yandex.net/crm-frontend/storybook/'$BRANCH'/index.html", "text": "Go to Storybook", "status": "SUCCESSFUL" }' >> $RESULT_BADGES_PATH/file`;

const deployStorybook = {
  title: 'Deploy to Storybook',
  task: 'common/misc/run_command',
  requirements,
  input: {
    config: {
      secret_environment_variables: [
        { key: 'AWS_ACCESS_KEY', secret_spec: { key: 'aws_access_key_id' } },
        { key: 'AWS__SECRET_ACCESS_KEY', secret_spec: { key: 'aws_secret_access_key' } },
        { key: 'TANKER_TOKEN', secret_spec: { key: 'tanker.token' } },
      ],
      arc_mount_config: { enabled: true },
      cmd_line: cmd,
      result_badges: [{ path: 'file' }],
    },
  },
};

module.exports = { deployStorybook };
