const { requirements } = require('../common.js');

const deployToMds = (mdsBucket) => {
  const cmd = `cd crm/space/frontend_static
export distFolder={dist_folder}
export TARGET_BUCKET_FOLDER=${mdsBucket}
bash ci/jobs/deployToMds.bash`;
  return {
    title: 'Deploy to MDS',
    task: 'common/misc/run_command',
    requirements,
    input: {
      config: {
        environment_variables: [
          {
            key: 'VERSION',
            value: '${tasks.calculate-version.result_output[0].string[0]}',
          },
        ],
        secret_environment_variables: [
          { key: 'AWS_ACCESS_KEY', secret_spec: { key: 'aws_access_key_id' } },
          { key: 'AWS__SECRET_ACCESS_KEY', secret_spec: { key: 'aws_secret_access_key' } },
        ],
        sandbox_resource_placeholders: [{ key: 'dist_folder', resource_type: 'OTHER_RESOURCE' }],
        arc_mount_config: { enabled: true },
        cmd_line: cmd,
      },
    },
  };
};

module.exports = { deployToMds };
