const { hermioneRequirements } = require('../common.js');

const cmd = `cd crm/space/frontend_static
yarn add @yandex-int/palmsync hermione@^4.7.6 html-reporter @yandex-int/hermione-surfwax-router --registry https://npm.yandex-team.ru
runPalmsync=\${flow-vars.palmsync}
keyword=\${flow-vars.keyword}
if [ "$runPalmsync" == "Yes" ]; then
  yarn run palmsync validate
  yarn run palmsync synchronize
fi
if [ "$keyword" != "" ]; then
  echo "run with GREP by $keyword"
  yarn run hermione --grep $keyword
else
  echo "run without GREP"  
  yarn run hermione
fi
export reportFolder=$RESULT_RESOURCES_PATH/report
mkdir $reportFolder  
cp -r html-results/. $reportFolder`;

const hermione = {
  title: 'Hermione tests',
  task: 'common/misc/run_command',
  requirements: hermioneRequirements,
  input: {
    config: {
      secret_environment_variables: [
        { key: 'TANKER_TOKEN', secret_spec: { key: 'tanker.token' } },
        {
          key: 'ROBOT_ODYSSEY_TOKEN',
          secret_spec: { key: 'token', uuid: 'sec-01en847g4zysd3x2ykhag5bags' },
        },
        {
          key: 'SANDBOX_AUTH_TOKEN',
          secret_spec: { key: 'sandbox_oauth_token', uuid: 'sec-01en847g4zysd3x2ykhag5bags' },
        },
        {
          key: 'palmsync_testpalmToken',
          secret_spec: { key: 'testpalm_oauth_token', uuid: 'sec-01en847g4zysd3x2ykhag5bags' },
        },
      ],
      arc_mount_config: { enabled: true },
      cmd_line: cmd,
      result_resources: [
        {
          path: 'report',
          description: 'Test report',
          type: 'OTHER_RESOURCE',
          compression_type: 'none',
          ci_badge: true,
          ci_badge_path: 'index.html',
        },
      ],
    },
  },
};

module.exports = { hermione };
