const { requirements } = require('../common.js');

const cmd = `cd crm/space/frontend_static
yarn
yarn run build
`;

const prBuild = {
  title: 'PR build',
  task: 'common/misc/run_command',
  requirements,
  input: {
    config: {
      secret_environment_variables: [{ key: 'TANKER_TOKEN', secret_spec: { key: 'tanker.token' } }],
      arc_mount_config: { enabled: true },
      cmd_line: cmd,
      logs_config: {
        redirect_stderr_to_stdout: true,
      },
    },
  },
};

module.exports = { prBuild };
