const { requirements } = require('../common.js');

const cmd = `cd crm/space/frontend_static
yarn
yarn test
exitCode=$? 
mkdir $RESULT_RESOURCES_PATH/report
cp -r html-report/. $RESULT_RESOURCES_PATH/report
echo "CUSTOM ERROR"
exit $exitCode
`;

const unitTests = {
  title: 'Unit tests',
  task: 'common/misc/run_command',
  requirements,
  input: {
    config: {
      secret_environment_variables: [{ key: 'TANKER_TOKEN', secret_spec: { key: 'tanker.token' } }],
      arc_mount_config: { enabled: true },
      cmd_line: cmd,
      result_resources: [
        {
          path: 'report',
          compression_type: 'none',
          description: 'Unit tests report',
          type: 'OTHER_RESOURCE',
          ci_badge: true,
          ci_badge_path: 'report.html',
        },
      ],
      logs_config: {
        redirect_stderr_to_stdout: true,
      },
    },
  },
};

module.exports = { unitTests };
