const { requirements } = require('../common.js');

const updateDeployStage = (title, stageName, mdsBucket, isDraft = 'no') => {
  const cmd = `export TARGET_BUCKET_FOLDER=${mdsBucket}
node crm/space/frontend_static/ci/jobs/updateStage.js bucketPath=$TARGET_BUCKET_FOLDER version=$VERSION stage=$STAGE_NAME isDraft=$IS_DRAFT`;
  return {
    title,
    task: 'common/misc/run_command',
    requirements,
    input: {
      config: {
        environment_variables: [
          {
            key: 'VERSION',
            value: '${tasks.calculate-version.result_output[0].string[0]}',
          },
          { key: 'STAGE_NAME', value: stageName },
          { key: 'IS_DRAFT', value: isDraft },
        ],
        secret_environment_variables: [
          { key: 'DCTL_YP_TOKEN', secret_spec: { key: 'dctl.token' } },
        ],
        arc_mount_config: { enabled: true },
        cmd_line: cmd,
      },
    },
  };
};

module.exports = { updateDeployStage };
