const { requirements } = require('../common.js');

const cmd = `cd crm/space/frontend_static
echo $VERSION > $RESULT_RESOURCES_PATH/lastSuccessVersion.txt
`;

const updateSuccessVersion = {
  title: 'Update last success version',
  task: 'common/misc/run_command',
  requirements,
  input: {
    config: {
      environment_variables: [
        {
          key: 'VERSION',
          value: '${tasks.calculate-version.result_output[0].string[0]}',
        },
      ],
      arc_mount_config: { enabled: true },
      cmd_line: cmd,
      result_resources: [
        {
          path: 'lastSuccessVersion.txt',
          description: 'Last Success Version',
          type: 'OTHER_RESOURCE',
          compression_type: 'none',
          attributes: {
            crm_frontend_static_release_branch: '${context.branch}',
          },
        },
      ],
    },
  },
};

module.exports = { updateSuccessVersion };
