const { requirements } = require('../common.js');

const cmd = `cd crm/space/frontend_static
npm install axios
node ./ci/jobs/updateIssues.js stToken=$ST_TOKEN issues=$ISSUES version=$VERSION`;

const updateTickets = {
  title: 'Update tickets',
  task: 'common/misc/run_command',
  requirements,
  input: {
    config: {
      arc_mount_config: { enabled: true },
      secret_environment_variables: [{ key: 'ST_TOKEN', secret_spec: { key: 'st.token' } }],
      environment_variables: [
        {
          key: 'ISSUES',
          value: `\${not_null(tasks.get-issues.changelog.issues, ['']) | join(',', @)}`,
        },
        {
          key: 'VERSION',
          value: '${tasks.calculate-version.result_output[0].string[0]}',
        },
      ],
      cmd_line: cmd,
    },
  },
};

module.exports = { updateTickets };
