const { execSync } = require('child_process');
const { getHotfixPatchNumber } = require('./utils/getHotfixPatchNumber');

const myArgs = process.argv.slice(2).reduce((acc, item) => {
  const [key, value] = item.split('=');
  acc[key] = value;
  return acc;
}, {});

const { revision, branch, launchNumber, flowType } = myArgs;

if (!branch) {
  throw new Error(`the branch cannot be empty`);
}
if (!launchNumber) {
  throw new Error(`the launchNumber cannot be empty`);
}

const branchSuffix = branch.split('/').pop();
const isUserBranch = /^users/.test(branch);

(async () => {
  async function getReleaseVersion() {
    let version = branchSuffix.replace('release-', '');
    let minor;
    if (flowType === 'HOTFIX') {
      minor = await getHotfixPatchNumber(branch);
    }

    if (minor) {
      const splittedVersion = version.split('.');
      splittedVersion.pop();
      version = `${splittedVersion.join('.')}.${minor}`;
    }
    return (version += `.${launchNumber}`);
  }

  let buildVersion;

  if (/^release-/.test(branchSuffix)) {
    buildVersion = await getReleaseVersion();
  }

  if (/^pr:/.test(branchSuffix)) {
    buildVersion = `pull-requests.${branchSuffix.split(':').pop()}.${launchNumber}`;
  }

  if (isUserBranch) {
    buildVersion = `${branchSuffix}.${launchNumber}`;
  }

  if (!buildVersion) {
    buildVersion = `trunk.${revision}.${launchNumber}`;
  }

  execSync(`echo ${buildVersion} > $RESULT_RESOURCES_PATH/version`);
})();
