const fs = require('fs');
const path = require('path');
const zlib = require('zlib');
const { pipeline } = require('stream');
const { promisify } = require('util');

const pipe = promisify(pipeline);

const dirs = ['vendor', 'dist'];

const compressors = [
  {
    createCompress: () =>
      zlib.createBrotliCompress({ params: { [zlib.constants.BROTLI_PARAM_QUALITY]: 11 } }),
    extension: 'br',
  },
  { createCompress: () => zlib.createGzip(), extension: 'gz' },
];

function getAllFiles(dirPath, arrayOfFiles) {
  const files = fs.readdirSync(dirPath);

  arrayOfFiles = arrayOfFiles || [];

  files.forEach(function(file) {
    if (fs.statSync(dirPath + '/' + file).isDirectory()) {
      arrayOfFiles = getAllFiles(dirPath + '/' + file, arrayOfFiles);
    } else {
      arrayOfFiles.push(path.join(process.cwd(), dirPath, '/', file));
    }
  });

  return arrayOfFiles;
}

dirs.forEach(async (dir) => {
  if (!fs.existsSync(dir)) {
    return;
  }

  const files = getAllFiles(dir).filter((file) => file.endsWith('.js') || file.endsWith('.css'));

  await Promise.all(
    files.map(async (filename) => {
      for (const { createCompress, extension } of compressors) {
        const fileContents = fs.createReadStream(filename);
        const writeStream = fs.createWriteStream(`${filename}.${extension}`);

        await pipe(fileContents, createCompress(), writeStream);
      }
    }),
  );
});
