const axios = require('axios').default;

const myArgs = process.argv.slice(2).reduce((acc, item) => {
  const [key, value] = item.split('=');
  acc[key] = value;
  return acc;
}, {});

const { stToken, version, issues } = myArgs;
const http = axios.create({
  baseURL: 'https://st-api.yandex-team.ru/v2/',
  timeout: 5000,
  headers: { Authorization: `Bearer ${stToken}` },
});

const versionWithoutBuild = `space-${version
  .split('.')
  .slice(0, -1)
  .join('.')}`;

(async () => {
  if (issues) {
    issues.split(',').forEach(async (issue) => {
      const { data } = await http.get(`issues/${issue}`);
      let versions = [versionWithoutBuild];
      if (data.fixVersions) {
        const currentVersions = data.fixVersions.map((version) => version.display);
        const versionsCollection = new Set([...currentVersions, versionWithoutBuild]);
        versions = Array.from(versionsCollection);
      }
      await http.patch(`issues/${issue}`, { fixVersions: versions });
    });
  }
})();
