const { execSync } = require('child_process');
const fs = require('fs');

const myArgs = process.argv.slice(2).reduce((acc, item) => {
  const [key, value] = item.split('=');
  acc[key] = value;
  return acc;
}, {});

const { version, stage, isDraft, bucketPath } = myArgs;

if (!version) {
  throw new Error(`the version cannot be empty`);
}
if (!stage) {
  throw new Error(`the stage cannot be empty`);
}

const mdsEnvRegexp = /^((.|\n)*?MDS_STATIC_BUILD_PATH(.|\n)+?literal_env(.|\n)+?value:)(.+)((.|\n)*)$/;

const configYaml = execSync(`ya tool dctl get stage ${stage}`).toString();

const matchMdsEnv = configYaml.match(mdsEnvRegexp);

if (!matchMdsEnv) {
  throw new Error('can not find env var for change');
}

const newConfig = matchMdsEnv[1] + ` s3://crm-public/${bucketPath}/${version}` + matchMdsEnv[6];

fs.writeFileSync('./config.patch.yaml', newConfig);
execSync('ya tool dctl --version');
if (isDraft === 'yes') {
  execSync(
    `ya tool dctl publish-draft stage ./config.patch.yaml --message "Static release: ${version}"`,
  );
} else {
  execSync('ya tool dctl put stage ./config.patch.yaml');
}
