const axios = require('axios').default;

const http = axios.create({
  baseURL: 'https://sandbox.yandex-team.ru/api/v1.0/',
  headers: {
    'Content-Type': 'application/json',
  },
});

const getHotfixPatchNumber = async (branch) => {
  const params = { attrs: { crm_frontend_static_release_branch: branch }, limit: 10, order: '-id' };
  const {
    data: { items },
  } = await http.get('resource', { params });
  if (items.length === 0) {
    return 1;
  }
  const lastSuccessPatchResource = items.pop();
  const { data: lastSuccessVersion } = await http.get(lastSuccessPatchResource.http.proxy);
  const patchNumber = lastSuccessVersion.split('.').slice(2, 3);
  return Number(patchNumber) + 1;
};

module.exports = { getHotfixPatchNumber };
