## Логи приложения в кибане
prod: https://logs.crm.in.yandex.net/  
test: https://logs.crm-test.in.yandex.net/  
пароли: https://yav.yandex-team.ru/?search=kibana  

### Базовые запросы
1) https://nda.ya.ru/t/0s1I-b2O4hDBMf – поиск вызова ручки **actions/log/info**
1) https://nda.ya.ru/t/j-hoqPs24hDCTd – поиск логов по xiva
1) https://nda.ya.ru/t/6CUHRQU34hDCkv – просмотр лога по processId

## UX логи в Rum и YT 
В некторых местах(например категоризатор или атрибуты issue) мы собираем UX логи и фиксируем действия пользователя и порядок этих действий (User Flow).

Каждое действие фиксируется как сущность `Event` в котором описаны детали произошедшего (что, где, в каком компоненте) и также добавляем некоторый `Additional` с доп данными о событии. 
### Как уезжают данные
В качестве сервиса для логирования мы используем [RUM.](https://wiki.yandex-team.ru/velocity/rum/)

Каждый event уезжает в виде timeMark-a с additional данными.
### Как отправить логи
Все компоненты отправляют логи через [RumProvider](https://github.yandex-team.ru/CRM/crm-frontend/blob/develop/src/services/Rum/RumProvider/RumProvider.ts)
Пример использования [тут](https://github.yandex-team.ru/barbate/crm-frontend/blob/3d60811f7de7f585396d5876c8d7d493f7c10bea/src/services/IntersectionWatcher/utils/sendIntresectionTimeMark.ts#L12)

⚠️ ***ВАЖНО*** Если вы пишите UX логи, добавляйте в название эвента префикс *UX_* - это позволяет легко их парсить при импорте в YT
### Где хранятся и как посмотреть данные
Первично данные через сервис RUM уезжают в быстрое (появляются там примерно через 20 секунд после отправки события) хранилище в ClickHouse.

Поскольку данные там хранятся ⚠️ ***21 день*** ⚠️ мы их импортируем к себе в [YT](https://yt.yandex-team.ru/hahn/navigation?path=//home/crm/rum) с помощью [таски](https://sandbox.yandex-team.ru/task/1088464718/view) настроенной на регулярную переливку.

***Посмотреть данные можно тут:***
 - (Рекомендуемое ⚠️ ***надо уметь в YQL*** ⚠️) Через ClickHouse - все данные которые были отправлены в ***additional*** к событию, храняться в 2 массивах - *kv_keys* и *kv_values* (в первом ключи, во втором значения). [пример запроса](https://yql.yandex-team.ru/Operations/YVa3dtjKS6LSLBS7CMOi4ol1ovhpumVP9_H9JEdf9kg=) 
 - (Не самое удобное представление) В нашем DashBoard для проекта в RUM - https://rum.yandex-team.ru/projects/crm-space
Все основные детали в разделе ***items***, во вкладке ***Timemark***
 - (это больше для аналитиков) Через [YT](https://yt.yandex-team.ru/hahn/navigation?path=//home/crm/rum) - это  метод медленее и не такой удобный, как в ClickHouse, но позволяет смотреть данные старше 21 дня с момента события.  

## Логирование ошибок в ErrorBooster

### Основные ссылки
1. Борда в errorBooster - https://error.yandex-team.ru/projects/crm-space/
2. Нотификашки в jugler (не только из RUM) - https://juggler.yandex-team.ru/notification_rules?project=crm
3. Борда с графиками в головане (RealTime) - https://yasm.yandex-team.ru/panel/barbate._on067V
4. Репозиторий с документацией error-counter - https://github.yandex-team.ru/RUM/error-counter

### Про ошибки
На фронте сейчас регистрируются и логируются 3 основных вида ошибок:

1. Ошибки логики фронтовой (попытка получить свойство из null, вызов несуществующих функций и все такое)
2. Необработанные ошибки в промисах (unhandledrejection)
3. Ошибки бэкэнда (любые ответы отличные от 200)
    
По сути логирование ошибок в errorBooster работет поверх RUM логирования (см. выше) и хранится также 21 день в ClickHouse

### Общие термины
**ReqId** - уникальный ключ запроса. новый на каждую перезагрузку страницы и на каждый таб.

**Source** - Источник ошибки, сейчас разделяем на Frontend и Backend

**SourceType** - Больше актуально для backend ошибок, позвляет групировать ошибки бэкэнда по коду ответа ручки

**Additionals** - это полезная информация которую мы отправляем вместе ошибкой (сейчас логин и uid)

### Как смотреть и фильтровать ошибки
Главый экран борды - это [сводная информация](https://error.yandex-team.ru/projects/crm-space/). На нем изображен график с количеством ошибок, описание ошибок, сводная информация о платформах, бразуерах и окружениях в которых возникали ошибки.

Ошибки делятся на 2 условные группы - frontend и backend. 

Все ошибки фронтовой логики и unhandledrejection это **Frontend**. Остальное **Backend**.

Отфильтровать можно по параметру ***source*** как например [тут](https://error.yandex-team.ru/projects/crm-space/sources).
Кликаете на нужный источник ошибки и выборка фильтруется. Кстати примененные фильтры отображаются и редактируются в строке фильтрации

![фильтрация по сорсам](https://jing.yandex-team.ru/files/barbate/ezgif.com-gif-maker%20%283%29.gif)

Ровно также можно (и нужно) фильтровать по domain, reqID, URLs  и другим параметрам.

### Как разобрать конкретную фронтовую ошибку со стэктрейсом
1. Выбираем нужную ошибку и проваливаемся в нее
2. Переходим в раздел stacktraces
3. Наводим курсор на блок со стэктрейсом и там появится маленькая кнопка в нижнем левом углу stacktraces - жми ее
4. Там тебе на выбор дается несколько представлений (Parsed, Original, Parsed+ sourceMap, Parsed+Minified) - читай любой.

![разбор ошибки](https://jing.yandex-team.ru/files/barbate/ezgif.com-gif-maker%20%285%29.gif)

ВАЖНО: если вдруг stacktrace не "раскукожился" и sourceMap не подтянулись, возможно внизу есть кнопока с предложением подгрузить сорсы, посмотри внимательно
![подгрузить сорсы](https://jing.yandex-team.ru/files/barbate/2021-12-15_14-10-07.png)

### Как посмотреть таймлайн в рамках ReqId

Это может быть полезным, если ты хочешь понять что предшествовало какой-то фронтовой ошибке. Например некоректный ответ бэка.

1. Открываешь нужную ошибку кликнув на нее
2. Далее переходишь в Request Ids и наводишь на нужный reqId
3. на нем появляется кнопочка timeline (справа) - жми на нее
4. Откроется таймлайн с событиями которые пишет Rum (там не только ошибки). Если у тебя только ошибки, то скорее всего у тебя настроен фильтр типа ***source==frontend***

![просмотр таймлайна](https://jing.yandex-team.ru/files/barbate/ezgif.com-gif-maker%20%286%29.gif)

### Как отфильтроваться по пользователю в Борде Error

С в additional с каждой ошибкой приезжает информация о пользователе, поэтому чтобы отфильтровать ошибки по конкретному пользователю нужно сделать следующее:

![фильтрация по пользователю](https://jing.yandex-team.ru/files/barbate/ezgif.com-gif-maker%20%288%29.gif)

1. в поле фильтрации напиши поле по которому хочешь фильтровать - в нашем случае это `additionalKeyValue`
2. пример фильтра может выглядеть так `additionalKeyValue in "user: {\"id\":147287,\"login\":\"aleksvolkov\"}"`

Не пугайся длинных строк, там работет автокомплит и ты быстро найдешь нужного пользователя.

### Как смотреть логи фронта и бэка

![смотрим логи рума и кибаны](https://jing.yandex-team.ru/files/barbate/ezgif.com-gif-maker%20%289%29.gif)

1. Открой борду [error-booster](https://error.yandex-team.ru/projects/crm-space/)
2. Сначала надо выбрать пользователя и временной интервал (как отфильтроваться по пользователю смотри выше)
3. Для просмотра ошибок бэка открой кибану [прод](https://logs.crm.in.yandex.net) или [тест](https://logs.crm-test.in.yandex.net).
Как попасть в кибану смотри в начале этого документа.
4. У тебя есть логин пользователя, который ты можешь использовать для фильтрации в кибане. В кибане в секунду времени происходит много всего, поэтому выбирай точный диапазон времени
5. Также если ты поймал ошибку бэка на фронте и хочешь посмотреть логи на бэке, можешь использовать параметр `wid` который приезжает в `additional`. Для этого скопируй значение `wid` и в кибане отфильтруйся по полю `processid` со значением `wid` которое ты скопировал. Смотри картинку ниже

![фильтрация по processId](https://jing.yandex-team.ru/files/barbate/2022-01-24_16-36-33.png)

### Как отфильтровать timeline сессии по определенному событию
![фильтрация по timelineItem](https://jing.yandex-team.ru/files/barbate/2022-01-25_09-06-58.png)
с каждой ошибкой или логом отправленным через логгер, в additional будет добавлен специальный параметр дублирующий название ошибки или лога  - `timelineItemName`

Чтобы отфильтровать таймлайн и показать только определенный тип событий можно написать следующее в строке фильтрации:
`additionalKeyValue in "timelineItemName: XivaClient"` , где `XivaClient` это название события. 

