declare const __DEV_FEATURE__: boolean;
declare const __APP_VERSION__: string;
declare const __FEATURES__: { [key: string]: boolean };

interface chatWidget {
  popup: { params: { targetNode: HTMLElement } };
  showChat: ({ guid: string }) => void;
  hideChat: () => void;
}

interface ChatWidgetConfig {
  iframeUrl: string;
  iframeUrlParams: { build: string };
  theme: string;
  popupTargetNode: HTMLElement;
  autocloseable: boolean;
}

interface ChatWidgetConstructor {
  new (config: ChatWidgetConfig): chatWidget;
}

interface Ym {
  (
    counter: number,
    reachGoal: 'reachGoal',
    goal: string,
    params?: import('modules/metrika').MetrikaParams,
  ): void;
  (counter: number, setUserId: 'setUserID', id: string): void;
  <P>(counter: number, userParams: 'userParams', params: { UserID?: number } & P);
}

interface Window {
  USER_ID?: number;
  __APP_VERSION__?: string;
  CRM_SPACE_API_HOST: string;
  WIKI_FORMATTER_CONFIG?: {
    lang?: string;
    instance?: string;
  };
  Ya?: {
    // eslint-disable-next-line
    FormatterViewPort?: any;
    // eslint-disable-next-line
    Rum?: any;
    ChatWidget?: ChatWidgetConstructor;
  };
  yaCounterHit: (url: string, data: unknown) => void;
  ym: Ym;
  COMPACT?: boolean;
  chatWidget?: chatWidget;
  scrollBarWidth: number;
  pinConfig?: import('types/PinConfig').PinConfig;
}

declare namespace NodeJS {
  interface Process {
    _original(): NodeJS.Process;
  }
}

declare module '*.react.svg' {
  const component: import('react').ComponentType<import('react').SVGAttributes<HTMLOrSVGElement>>;
  export default component;
}

declare module '*.png' {
  const filename: string;
  export default filename;
}

declare module '*.mdx';
