import { push } from 'modules/notificationsUI/actions';

export const uiToggleSelectQueueDialog = (
  visible,
  ticketId,
  formType = 'TICKET',
  rootId = null,
) => (dispatch) =>
  dispatch({
    type: 'UI_TOGGLE_SELECT_QUEUE_DIALOG',
    data: visible,
    currentTicketId: ticketId,
    formType,
    rootId,
  });

export const uiSelectQueue = (queueId) => (dispatch) =>
  dispatch({
    type: 'UI_SELECT_QUEUE',
    data: queueId,
  });

export const uiCurrentQueue = (queueId) => (dispatch) =>
  dispatch({
    type: 'UI_CURRENT_QUEUE',
    data: queueId,
  });

const SNACKBAR_TYPE = {
  INFO: 'default',
  ERROR: 'error',
  SUCCESS: 'success',
  WARN: 'warn',
};

export const uiToggleSnackbar = (visible, text = '', type = 'INFO') =>
  push({
    theme: SNACKBAR_TYPE[type],
    text,
  });
