import React, { FC } from 'react';
import { withOverlay } from 'components/Overlay';
import LegoButton, { ButtonProps } from '@crm/components/dist/lego2/Button';
import { ActionButtonProps } from './ActionButton.types';

const Button = withOverlay('isLoading')<ButtonProps & { isLoading?: boolean }>(LegoButton, {
  hasSpinner: true,
  zIndex: 10,
  size: 'xxs',
});

const buttonViewByTheme = {
  clean: 'pseudo',
};

export const ActionButton: FC<ActionButtonProps & Omit<ButtonProps, 'onClick'>> = ({
  action,
  disabled = false,
  theme,
  isLoading = false,
  onClick,
  ...other
}) => {
  const handleActionButtonClick = () => {
    onClick?.(action);
  };
  return (
    <Button
      disabled={disabled}
      onClick={handleActionButtonClick}
      isLoading={isLoading}
      view={buttonViewByTheme[theme] || 'default'}
      {...other}
    >
      {action.caption}
    </Button>
  );
};
