import { FormAction } from 'types/api/form/Form';
import { ItemSimple } from '@yandex-lego/components/Menu';

export const actionToOption = (action: FormAction): ItemSimple => {
  return {
    content: action.caption,
    value: action.id,
  };
};

export const getActionsTree = (actions: FormAction[]) => {
  const actionsTree = new Map<FormAction, FormAction[] | undefined>();
  actions.forEach((action) => {
    if (action.buttonType === 'Dropdown') {
      const items = actions.filter((item) => item.parentActionId === action.id);
      actionsTree.set(action, items);
    } else if (!action.parentActionId) {
      actionsTree.set(action, undefined);
    }
  });
  return actionsTree;
};
