import React from 'react';
import { FormByScheme } from 'components/FormByScheme';
import { UIServiceFormProps } from 'services/UserInteractionService';

const formScheme = {
  data: [],
  meta: {
    fields: [],
    fieldsVisibility: [],
  },
};

export const AlertForm: React.FC<UIServiceFormProps> = ({
  onSubmitSuccess,
  title,
  description,
}) => {
  return (
    <FormByScheme
      title={title}
      description={description}
      onSubmit={onSubmitSuccess}
      scheme={formScheme}
      successButtonText="Понятно"
    />
  );
};
