import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { ModalContainer } from 'lego/utils/modalForm';
import { AlertModalForm } from './AlertModalForm';

export default {
  title: 'AlertModal/AlertModalForm',
  component: AlertModalForm,
  argTypes: {
    onSubmitSuccess: { action: 'submitted' },
    onClose: { action: 'closed' },
  },
};

export const Default = (args) => (
  <>
    <Button
      onClick={() =>
        AlertModalForm.open({
          title: 'Achtung!',
          description: 'Что-то случилось',
          onSubmitSuccess: args.onSubmitSuccess,
          onClose: args.onClose,
        })
      }
    >
      open modal
    </Button>
    <ModalContainer />
  </>
);
