// TODO fix order make sense here
/* eslint-disable import/order */
import React, { useEffect } from 'react';
import PropTypes from 'prop-types';
import Footer from 'components/Footer';
import FileViewer from 'components/FileViewer';
import { Notifications } from 'modules/notificationsUI';
import SelectQueueDialog from 'components/dialog/SelectQueueDialog';
import { PhoneInit } from 'modules/phone';
import UserState from 'modules/userState';
import IssuePreview from 'modules/issuePreview/components/Preview.connect';
import { PinModalObserver } from 'modules/pinForm';
import 'material-design-icons/iconfont/material-icons.css';
import 'styles/global.css';
import cx from 'classnames';
import { ModalContainer } from 'lego/utils/modalForm';
import AppHeader from './AppHeader';
import css from './App.module.css';
import { ConfirmModalForm } from 'components/ConfirmForm';
import { userInteractionService } from 'services/UserInteractionService';
import { configureRootTheme } from '@yandex-lego/components/Theme';
import { crmMgLightTheme } from '@crm/components/dist/lego2/Theme/presets/themes';
import { config } from 'services/Config';
import { getIsSupportedBrowser } from 'services/SupportedBrowsers';
import { UnsupportedBrowser } from 'components/UnsupportedBrowser';
import { AlertModalForm } from '../AlertModalForm';
import { PersonalCallServiceProvider } from 'services/PersonalCallService';
import { CallToastContainer } from '../CallToast';

const App = (props) => {
  const { children } = props;

  const isBrowserSupported = getIsSupportedBrowser();

  useEffect(() => {
    configureRootTheme({ theme: crmMgLightTheme });
    userInteractionService.setConfirmView(ConfirmModalForm);
    userInteractionService.setAlertView(AlertModalForm);
  }, []);

  if (!isBrowserSupported) {
    return (
      <div className={css.root}>
        <div className={css.container}>
          <UnsupportedBrowser />
        </div>
      </div>
    );
  }

  return (
    <div className={cx(css.root, { [css.root_compact]: window.COMPACT })}>
      {!window.COMPACT && <AppHeader />}
      <div className={css.container}>{children}</div>
      <Footer className={css.footer} />
      <Notifications />
      <FileViewer />
      <SelectQueueDialog />
      <PhoneInit />
      <UserState />
      <ModalContainer />
      <IssuePreview />
      <PinModalObserver />
      {config.value.features.personalUnits && (
        <PersonalCallServiceProvider>
          <CallToastContainer />
        </PersonalCallServiceProvider>
      )}
    </div>
  );
};

App.propTypes = {
  children: PropTypes.node,
};

App.defaultProps = {
  children: undefined,
};

export default App;
