import React, { useContext } from 'react';
import { MediaMatchContext, DeviceType } from 'components/MediaMatch';
import Header from 'components/Header';
import css from './App.module.css';

const AppHeader = () => {
  const deviceType = useContext(MediaMatchContext);

  let theme: 'side' | 'top' = 'side';

  if (deviceType === DeviceType.Phone) {
    theme = 'top';
  }

  return <Header className={css.header} theme={theme} />;
};

export default AppHeader;
