import React, { ComponentType } from 'react';
import { config } from 'services/Config';
import WebphoneFloat from 'modules/webphone/components/WebphoneFloat';
import { WebphoneProvider } from 'modules/webphone/components/WebphoneContext/WebphoneContext';

export const withYaCalls = (WrappedComponent: ComponentType) => {
  const WithYaCalls = (props) => {
    const { children, ...other } = props;

    const shouldMountWebphone =
      config.value.features.useYaCalls ||
      (config.value.features.useYaCallsLB && !config.value.useExternalPhone);

    if (shouldMountWebphone) {
      return (
        <WebphoneProvider>
          <WrappedComponent {...other}>
            {children}
            <WebphoneFloat />
          </WrappedComponent>
        </WebphoneProvider>
      );
    }

    return <WrappedComponent {...props} />;
  };

  return WithYaCalls;
};
