import React, { useState } from 'react';
import RadioButton from '@crm/components/dist/lego2/RadioButton';
import { SimpleAsyncComponent } from 'components/AsyncRender/AsyncRender.stories';
import { AsyncTransition } from './AsyncTransition';
import { AsyncTransitionState } from './AsyncTransition.types';

type FormType = 'comment' | 'mail' | 'chat';

interface CommunicationFormTransitionState extends AsyncTransitionState {
  hash: FormType;
  title: string;
}

const states: Record<FormType, CommunicationFormTransitionState> = {
  chat: { hash: 'chat', title: 'chat (error)' },
  mail: { hash: 'mail', totalSubTasks: 2, title: 'mail (nested async)' },
  comment: { hash: 'comment', totalSubTasks: 0, title: 'comment (sync)' },
};

export const CommunicationFormExample = () => {
  const [tab, setTab] = useState('chat');

  return (
    <div>
      <div style={{ position: 'relative', minHeight: 100 }}>
        <AsyncTransition
          state={states[tab]}
          onTransitionError={(prevState) => setTab(prevState.hash)}
        >
          {(state) => {
            if (state.hash === 'comment') {
              return <SimpleAsyncComponent style={{ height: 100 }} title="CommentForm" />;
            }

            if (state.hash === 'mail') {
              return (
                <SimpleAsyncComponent style={{ height: 200 }} title="MailForm">
                  <SimpleAsyncComponent title="MailEditor" />
                </SimpleAsyncComponent>
              );
            }

            return <SimpleAsyncComponent style={{ height: 100 }} title="ChatForm" isError />;
          }}
        </AsyncTransition>
      </div>
      <RadioButton
        value={tab}
        isEventValue={false}
        size="s"
        onChange={setTab as never}
        options={Object.entries(states).map(([key, value]) => ({
          value: key,
          children: value.title,
        }))}
      />
    </div>
  );
};
