import React, { CSSProperties } from 'react';

export interface AsyncTransitionState {
  hash: string | number;
  isForceMountNextState?: boolean;
  totalSubTasks?: number;
}

export interface TransitionSuccessPayload<S extends AsyncTransitionState = AsyncTransitionState> {
  currentState: S;
  prevState: S;
}

export interface AsyncTransitionProps<S extends AsyncTransitionState = AsyncTransitionState> {
  state: S;
  onTransitionSuccess?: (payload: TransitionSuccessPayload<S>) => void;
  onTransitionError?: (state: S) => void;
  className?: string;
  style?: CSSProperties;
  children: (state: S) => React.ReactNode;
}
