import React, { useRef } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { AttachFilesButtonProps } from './AttachFilesButton.types';

export const AttachFilesButton: React.FC<AttachFilesButtonProps> = ({
  onClick,
  onFilesChange,
  fileInputRef,
  ...props
}) => {
  const inputRef = useRef<HTMLInputElement>(null);

  const handleClick = () => {
    inputRef.current?.click();
    if (onClick) {
      onClick();
    }
  };

  const handleChange = (event) => {
    fileInputRef?.current?.addFiles?.(event.target.files);
    if (onFilesChange) {
      onFilesChange(event.target.files);
    }
  };

  return (
    <>
      <input
        ref={inputRef}
        onChange={handleChange}
        hidden
        type="file"
        id="file"
        name="file"
        multiple
        value=""
      />
      <Button
        icon={(cls) => <Icon className={cls} svg="attach" />}
        title="Прикрепить файлы"
        area-label="templates"
        view="clear"
        onClick={handleClick}
        {...props}
      />
    </>
  );
};
