import React from 'react';
import {
  AttachFilesDNDContainer,
  AttachFilesDND,
  AttachFilesDNDContainerProps,
  AttachFilesDNDScope,
} from '.';

export default {
  title: 'AttachFilesDND',
  argTypes: {
    scope: {
      name: 'Drop Scope',
      control: {
        type: 'boolean',
      },
    },
  },
};

const AttachZone: React.FC<AttachFilesDNDContainerProps & {
  title: string;
  disabled?: boolean;
}> = ({ children, title, style, disabled }) => (
  <AttachFilesDNDScope disabled={disabled}>
    <AttachFilesDNDContainer
      style={{ flex: 1, backgroundColor: '#aaa', padding: 10, minHeight: 100, ...style }}
    >
      <h3 style={{ margin: 0, textAlign: 'center', marginBottom: 20 }}>{title}</h3>
      {children}
    </AttachFilesDNDContainer>
  </AttachFilesDNDScope>
);

export const DropZones = ({ scope }) => {
  return (
    <div style={{ display: 'flex', flex: 1, flexDirection: 'column' }}>
      <AttachZone title="Контейнер 1" style={{ backgroundColor: '#aaa' }}>
        <AttachZone
          title="Контейнер 2.1"
          disabled={!scope}
          style={{ backgroundColor: '#ccc', marginTop: 100 }}
        >
          <AttachFilesDND
            zones={[
              {
                text: 'Перетащите файлы сюда для Контейнер 2.1',
                onDrop: () => {},
              },
            ]}
          />
        </AttachZone>
        <AttachZone
          title="Контейнер 2.2"
          disabled={!scope}
          style={{ backgroundColor: '#ccc', marginTop: 20 }}
        >
          <AttachFilesDND
            zones={[
              {
                text: 'Перетащите файлы сюда для Контейнер 2.2',
                onDrop: () => {},
              },
            ]}
          />
        </AttachZone>
      </AttachZone>
    </div>
  );
};

DropZones.args = {
  scope: false,
};
