import React, { useContext, useEffect } from 'react';
import { AttachFilesDNDProps } from './AttachFilesDND.types';
import { AttachFilesDNDContext } from './AttachFilesDNDService';

export const AttachFilesDND: React.FC<AttachFilesDNDProps> = ({ zones = [] }) => {
  const attachFilesDNDContext = useContext(AttachFilesDNDContext);

  useEffect(() => {
    attachFilesDNDContext?.addZones(zones);
    return () => {
      attachFilesDNDContext?.removeZones(zones);
    };
  }, [attachFilesDNDContext, zones]);

  return null;
};
