import React, { useContext, useMemo } from 'react';
import cx from 'classnames';
import { MultiOverlayDropZone } from 'components/MultiOverlayDropZone';
import { observer } from 'mobx-react-lite';
import { AttachFilesDNDContainerProps } from './AttachFilesDNDContainer.types';
import { AttachFilesDNDContext, AttachFilesDNDService } from '../AttachFilesDNDService';
import css from './AttachFilesDNDContainer.module.css';

export const AttachFilesDNDContainer: React.FC<AttachFilesDNDContainerProps> = observer(
  ({ children, className, style }) => {
    const currentContext = useMemo(() => new AttachFilesDNDService(), []);
    const previousContext = useContext(AttachFilesDNDContext);

    return (
      <div className={cx(css.AttachFilesDNDContainer, className)} style={style}>
        <AttachFilesDNDContext.Provider value={previousContext || currentContext}>
          {children}
        </AttachFilesDNDContext.Provider>
        {currentContext.dropZones.length > 0 && (
          <MultiOverlayDropZone zones={currentContext.dropZones} />
        )}
      </div>
    );
  },
);
