import { DropZone } from 'components/MultiOverlayDropZone';
import { makeAutoObservable } from 'mobx';

export class AttachFilesDNDService {
  private zones: Map<string, DropZone> = new Map();
  get dropZones(): DropZone[] {
    return Array.from(this.zones.values());
  }

  constructor() {
    makeAutoObservable(this);
  }

  public addZones = (zones: DropZone[]) => {
    zones.forEach((zone) => this.zones.set(zone.text, zone));
  };

  public removeZones = (zones: DropZone[]) => {
    zones.forEach((zone) => this.zones.delete(zone.text));
  };

  public clearZones = () => {
    this.zones.clear();
  };
}
