import { createForm } from 'final-form';
import Bluebird from 'bluebird';
import { AttachFilesServiceProps } from './AttachFilesService.types';

export const attachFilesServiceInitialStub = {
  name: 'name',
  objectName: 'objectName',
  containerId: 1,
  objId: 1,
  formApi: createForm({
    initialValues: { text: 'text' },
    onSubmit: () => {},
  }),
};

export const attachFilesServiceStub = {
  dropContainer: null,
  isFetch: false,
  promise: null,
  ...attachFilesServiceInitialStub,
  addFiles: () => null,
  updateFiles: () => new Bluebird(() => {}),
  removeFile: () => new Bluebird(() => {}),
  cancelPromise: () => {},
  setFetch: () => {},
  handleFilesChange: () => {},
} as Partial<AttachFilesServiceProps>;

export const attachFileStub = new File(['(⌐□_□)'], 'chucknorris.png', { type: 'image/png' });

export const responseAttachFilesStub = {
  files: [],
  containerId: attachFilesServiceInitialStub.containerId,
};
