import { FormApi } from 'final-form';
import Bluebird from 'bluebird';

export type AttachFilesServiceProps = AttachFilesServiceFields & AttachFilesServiceActions;

export interface AttachFilesServiceFields {
  name: string;
  objectName: string;
  containerId?: number;
  objId?: number;
  formApi?: FormApi;
}

export interface AttachFilesServiceActions {
  addFiles: (files: File[]) => Bluebird<void> | null;
  removeFile: (id) => Bluebird<void>;
  updateFiles: (fileIdsToLink: number[], fileIdsToRemove: number[]) => Bluebird<void>;
}
