import React, { useMemo, useEffect } from 'react';
import { observer } from 'mobx-react-lite';
import FilesList from 'components/FilesList';
import css from 'lego/components/AttachFiles/AttachFiles.modules.scss';
import { AttachFilesViewerProps } from './AttachFilesViewer.types';
import { AttachFilesService } from '../AttachFilesService';
import { createLoadingFiles } from './AttachFilesViewer.utils';

export const AttachFilesViewer: React.FC<AttachFilesViewerProps> = observer(
  ({ name, objectName, formApi, containerId, objId, files = [], fileInputRef }) => {
    const attachFilesService = useMemo(() => new AttachFilesService(), []);

    const getCurrentFiles = () => {
      return files || [];
    };

    const addFiles = (newFiles: File[]) => {
      attachFilesService.handleFilesChange({
        files: createLoadingFiles(newFiles).concat(files),
        containerId,
        objId,
        success: false,
      });

      return attachFilesService.addFiles(newFiles);
    };

    const removeFile = (id) => {
      const fileToRemove = files.find((file) => file.id === id);
      if (fileToRemove) {
        fileToRemove.isLoading = true;
      }

      return attachFilesService.removeFile(id);
    };

    const updateFiles = (fileIdsToLink: number[], fileIdsToRemove?: number[] | undefined) => {
      files.forEach((file) => {
        file.isLoading = true;
      });

      return attachFilesService.updateFiles(fileIdsToLink, fileIdsToRemove);
    };

    useEffect(() => {
      attachFilesService.init(name, objectName, formApi, containerId, objId);
      if (fileInputRef) {
        fileInputRef.current = {
          addFiles,
          updateFiles,
          removeFile,
          getCurrentFiles,
        };
      }
    }, [fileInputRef, name, objectName, formApi, containerId, objId]);

    return (
      <FilesList
        rootClassName={css.files}
        files={files}
        isInline
        onRemove={removeFile}
        inFileBox
        disabled={attachFilesService.isFetch}
        isFullName={false}
        forceUseFeatureIssueTimelineV2
      />
    );
  },
);
