import { MutableRefObject } from 'react';
import { BackendFile } from 'lego/components/AttachFiles/types';
import { AttachFilesServiceActions, AttachFilesServiceFields } from '../AttachFilesService';

export interface AttachFile extends BackendFile {
  isLoading?: boolean;
  disabled?: boolean;
}

export interface AttachFilesViewerProps extends AttachFilesServiceFields {
  files?: AttachFile[];
  fileInputRef?: MutableRefObject<AttachFilesViewerInputRef>;
}

export interface AttachFilesViewerInputRef extends AttachFilesServiceActions {
  getCurrentFiles: () => AttachFile[];
}
