import { AttachFile } from './AttachFilesViewer.types';

export const createLoadingFiles = (files: File[]): AttachFile[] => {
  return Array.from(files).map((file, index) => ({
    id: index,
    size: file.size.toString(),
    type: file.type,
    urlName: '',
    name: file.name,
    isLoading: true,
  }));
};
