import React from 'react';
import get from 'lodash/get';
import { BackendResponse } from 'lego/components/AttachFiles';
import { FormSpy, FormSpyRenderProps, FieldRenderProps } from 'react-final-form';
import withFinalFormField from 'lego/final-form/withFinalFormField';
import { AttachFilesViewerProps } from './AttachFilesViewer.types';
import { AttachFilesViewer } from './AttachFilesViewer';

const AttachFilesViewerSpy: React.FC<Omit<
  AttachFilesViewerProps,
  'containerId' | 'formApi' | 'files'
> &
  FieldRenderProps<BackendResponse>> = (props) => {
  const renderSpy = ({ form }: FormSpyRenderProps) => {
    let files = get(props, 'value.files');
    // TODO: https://st.yandex-team.ru/CRM-10614
    const containerId =
      props.containerId ||
      get(props, 'value.containerId') ||
      get(form.getState().values, 'containerId');

    if (Array.isArray(props.value)) {
      files = props.value;
    }

    return <AttachFilesViewer {...props} files={files} containerId={containerId} formApi={form} />;
  };

  return <FormSpy subscription={{}}>{renderSpy}</FormSpy>;
};

export const AttachFilesViewerField = withFinalFormField()(AttachFilesViewerSpy);
