import React, { FC } from 'react';
import cx from 'classnames';
import { AttachmentItemProps } from './AttachmentItem.types';
import css from './AttachmentItem.module.css';
import { Badge } from './Badge';
import { Delete } from './Delete';
import { Download } from './Download';

export const AttachmentItem: FC<AttachmentItemProps> = ({
  className,
  name = '',
  extension,
  shadow = false,
  previewImageUrl,
  backgroundColor = '#F1F0EF',
  nameColor = '#000',
  downloadUrl,
  onClick,
  onDelete,
  fileSize = '',
}) => {
  return (
    <div
      data-testid="attach-item"
      className={cx(css.AttachmentItem, className)}
      onClick={onClick}
      style={{
        backgroundColor: backgroundColor,
        backgroundImage: previewImageUrl ? `url(${previewImageUrl})` : undefined,
      }}
      title={`${name}${fileSize && ` (${fileSize})`}`}
    >
      <span
        data-testid="attach-item-file-name"
        className={css.AttachmentItem__name}
        style={{ color: nameColor }}
      >
        {name}
      </span>
      {extension && (
        <Badge className={css.AttachmentItem__badge} extension={extension} shadow={shadow} />
      )}
      {onDelete && <Delete className={css.AttachmentItem__delete} onDelete={onDelete} />}
      {downloadUrl && (
        <Download className={css.AttachmentItem__download} downloadUrl={downloadUrl} />
      )}
    </div>
  );
};
